### Importance of Host Groups

- **Critical for Security**: Proper use of host groups ensures relevant alerts and accurate information.
- **Maximizes Protection**: Helps in effective monitoring and incident response.

---

### What are Host Groups?

- **Definition**: Virtual containers for multiple host IP addresses/ranges with similar attributes (location, function, topology).
- **Flexibility**: Hosts can belong to one or more groups; organization is customizable by administrators.
- **Visibility**: Administrator privileges determine which host groups are visible in the Enterprise Tree.

---

### Host Group Structure

#### Primary Top-Level Host Groups

1. **Inside Hosts**
    - Contains hosts specifically defined as part of the internal network.
    - Includes subordinate groups based on function or location.
2. **Outside Hosts**
    - Contains hosts not defined as part of the internal network.
    - Includes subordinate groups such as Countries and Trusted Internet Hosts.
3. **Secure Network Analytics Threat Feed**
    - Automatically created groups containing known malicious entities.

---

### Details of Host Group Structure

#### Inside Hosts

- **Catch All Host Group**
    
    - Default group for all private IP ranges (RFC 1918, RFC 4193):
        - 10.0.0.0/8
        - 172.16.0.0/12
        - 192.168.0.0/16
        - fc00::/7
    - Cannot be renamed, moved, or deleted.
    - Should be regularly reviewed and eventually emptied as IPs are reassigned to more specific groups.
- **Other Subordinate Groups**
    
    - **By Function**: Group devices by network function for targeted policies.
    - **By Location**: Default groups for organizing IPs by physical or logical location.

#### Outside Hosts

- **Countries**: Uses GeoIP to group public IPs by geographic location.
- **Trusted Internet Hosts**: Initially empty; used for policy exceptions for acceptable internet hosts.

#### Threat Feed Host Groups (Automatic)

- **Bogon**: Unassigned public internet addresses.
- **Command & Control Servers**: Central servers used for botnets.
- **Tor**: IPs associated with the Tor anonymization network.

---

### Role of Host Groups in Monitoring and Policy

- **Behavior Monitoring**: Each host/group is monitored against baseline behaviors.
- **Policy Application**: Policies can be tailored for each group or individual host.
- **Alarm Reduction**: Proper grouping reduces false positives (e.g., DHCP servers).
- **Visual Indicators**: The Enterprise Tree uses color to indicate the highest alarm level within branches.

---

### Editing Host Groups

- **Desktop Client**: Right-click on the host group, choose Configuration > Edit Host Groups.
- **Manager WebUI (v7.0+)**: Right-click on the host group, choose Configure > Host Group Management.

---

### Best Practices

- **Initial Setup**: Place all large internal IP ranges in Catch All, then assign to specific groups.
- **Ongoing Management**: Regularly review and reassign IPs to appropriate groups to enhance monitoring accuracy.

---

**Note:**  
The color indicator in the Enterprise Tree visually represents alarm status for quick identification.

---

#### Example

- **Legitimate vs. Rogue Devices**: Assigning legitimate DHCP servers to a dedicated group prevents unnecessary alarms, while rogue devices outside defined groups will trigger alerts.